import os

import torch
from PIL import Image
from torch.utils.data import Dataset


class NIPS2017AdversarialCompetition(Dataset):

    def __init__(self, transform=None, requires_grad=None):
        self.images_root_dir = r'E:\datasets\NIPS2017_adversarial_competition\dev_dataset\my_images'
        self.real_labels = torch.load(r'E:\datasets\NIPS2017_adversarial_competition\dev_dataset\real_labels.pt')
        self.transform = transform
        self.requires_grad = requires_grad

    def __getitem__(self, item):
        filename = str(item) + '.png'
        label = self.real_labels[item]  # [0, 999]
        filepath = os.path.join(self.images_root_dir, filename)
        image = Image.open(filepath).convert('RGB')
        if self.transform:
            image = self.transform(image)
        if self.requires_grad:
            image.requires_grad = True
        return image, label

    def __len__(self):
        return self.real_labels.shape[0]
